# radicale.install:  
# https://radicale.org/v3.html
# docker-radicale: Docker image for Radicale calendar and contact server - https://github.com/tomsquest/docker-radicale
# - How to use sed to remove all double quotes within a file - Stack Overflow - https://stackoverflow.com/questions/7635807/how-to-use-sed-to-remove-all-double-quotes-within-a-file
alias rcal.install="radicale.install"
alias ical.install="radicale.install"
radicale.install(){

# Config vars #
app_domain="${1:-"cal.$org_domain"}"
app_user="${2:-"op"}" # Company domain name
app_name="rcal"
app_path="/data/${app_name}"
#app_version="0.2.0"
app_port="5232"
app_config="$app_path/config/config"
app_password=""
vault="/data/.vault/"
data_path="$app_path/${app_name}_data"
PUID="$(id -u)"
PGID="$(id -g)"


# Setup paths #
mkdir -p "$app_path/config"

echo cd "$app_path"
cd "$app_path"
if [ ! $? == "0" ];then
	err "Failed to cd \"$app_path\""
	return 1
fi

# Vault app password
if [[ ! -e "$vault/$app_name" ]];then
  # if empty then create password
  app_password="$(openssl rand -base64 32 | tr -cd "[:alnum:]")"
  echo "$app_password" > "$vault/$app_name"
fi
app_password="$(cat "$vault/$app_name")"


# Install App 3 #
echo git clone https://github.com/tomsquest/docker-radicale
git clone https://github.com/tomsquest/docker-radicale
cd ./docker-radicale
if [ ! $? == "0" ];then
	err "Failed to cd \"$app_path\""
	return 1
fi

# Reset and Update docker-radicale
echo git reset --hard origin
git reset --hard origin
echo git pull
git pull

# if file does not exists
if [[ ! -e "$app_path/config/config-example" ]];then
  # not exists
  echo cp --no-clobber "$app_path/docker-radicale/config" "$app_path/config/config-example"
  cp --no-clobber "$app_path/docker-radicale/config" "$app_path/config/config-example"
fi


# Setup User Password
if [[ ! -e "$app_path/config/users" ]];then
  # Create User
  touch "$app_path/config/users"
  echo htpasswd "$app_path/config/users" op
  htpasswd "$app_path/config/users" op
fi

# Setup Server Cert
if [[ ! -e "$app_path/config/server_cert.pem" ]];then
  # Create Server Cert
  echo openssl req -x509 -newkey rsa:4096 -keyout "$app_path/config/server_key.pem" -out "$app_path/config/server_cert.pem" -nodes -days 9999
  openssl req -x509 -newkey rsa:4096 -keyout "$app_path/config/server_key.pem" -out "$app_path/config/server_cert.pem" -nodes -days 9999

  echo openssl req -x509 -newkey rsa:4096 -keyout "$app_path/config/client_key.pem" -out "$app_path/config/client_cert.pem" -nodes -days 9999
  openssl req -x509 -newkey rsa:4096 -keyout "$app_path/config/client_key.pem" -out "$app_path/config/client_cert.pem" -nodes -days 9999
fi

echo chmod 644 "$app_path/config/"*.pem
chmod 644 "$app_path/config/"*.pem


#if [[ ! -e "$app_config" ]];then

rm "$app_config"
touch "$app_config"
dasel put -r toml -w toml -t string -f "$app_config" "server.hosts" -v "0.0.0.0:5232"
dasel put -r toml -w toml -t bool -f "$app_config" "server.ssl" -v "false"
dasel put -r toml -w toml -t string -f "$app_config" "server.certificate" -v "/config/server_cert.pem"
dasel put -r toml -w toml -t string -f "$app_config" "server.key" -v "/config/server_key.pem"
dasel put -r toml -w toml -t string -f "$app_config" "auth.type" -v "htpasswd"
dasel put -r toml -w toml -t string -f "$app_config" "auth.htpasswd_filename" -v "/config/users"
dasel put -r toml -w toml -t string -f "$app_config" "auth.htpasswd_encryption" -v "md5"
dasel put -r toml -w toml -t string -f "$app_config" "storage.filesystem_folder" -v "/data/collections"
dasel put -r toml -w toml -t string -f "$app_config" "web.type" -v "internal"
dasel put -r toml -w toml -t string -f "$app_config" "logging.level" -v "warning"
dasel put -r toml -w toml -t bool -f "$app_config" "logging.mask_passwords" -v "true"
dasel put -r toml -w toml -t string -f "$app_config" "headers.Access-Control-Allow-Origin" -v "*"


# Radicale config is not TOML compatable
# Quick Fix: Remove double quotes
sed -i 's/\"//g' "$app_config" 

#echo cat "$app_config"
#cat "$app_config"

#fi


# Create folder $data_path
echo sudo mkdir -p "$data_path"
sudo mkdir -p "$data_path"

# Set permissions $data_path
#echo sudo chown -R 1000:1000 "$data_path"
#sudo chown -R 1000:1000 "$data_path"

# Contain App. Write docker-compose config. 4
sudo tee "./docker-compose.yml" > /dev/null <<EOF
services:
  $app_name:
    image: tomsquest/docker-radicale
    container_name: $app_name-$(hostname)
    user: "$PUID:$PGID"
    environment:
      - PUID=$PUID
      - PGID=$PGID
      - USER_UID=$PUID
      - USER_GID=$PGID
    ports:
      - $app_port:5232
    init: true
    read_only: true
    security_opt:
      - no-new-privileges:true
    cap_drop:
      - ALL
    cap_add:
      - SETUID
      - SETGID
      - CHOWN
      - KILL
    healthcheck:
      test: curl -f https://$org_domain || exit 1
      interval: 30s
      retries: 3
    restart: always
    volumes:
      - "$data_path:/data:rw"
      - "$app_path/config:/config:rw"
EOF

echo web $app_path

echo cat ./docker-compose.yml
cat ./docker-compose.yml

# Run App. LIVE!
echo Running $app_name docker container in the background.
echo sudo docker-compose up -d
sudo docker-compose up -d

echo https://$(host.ip):$app_port


}
# ---