# rustdesk.install:  $app_domain
# https://github.com/rustdesk/rustdesk?tab=readme-ov-file#screenshots
# rustdesk.com/docs/en/self-host/
# github.com/rustdesk/rustdesk/wiki/How-does-RustDesk-work%3F
# TCP Ports: 21115,21116,21117,21118,21119
# UDP Port: 21116
rustdesk.install(){

# Config #
app_name="rd" # App Name
app_repo_url="https://github.com/rustdesk/rustdesk-server" # App Codebase
app_version="latest"
app_domain="${1:-"$app_name.$org_domain"}" # Unique app domain

app_name_domain="$(echo $app_domain | tr "." "-")"
app_path="/data/${app_name_domain}"
data_path="$app_path/${app_name}_data"
code_path="$app_path/$(basename $app_repo_url)"
container_name="$app_name-$app_port"
app_container_config="$code_path/docker-compose.yml"

# Setup #
mkdir -p "$app_path"

echo cd "$app_path"
cd "$app_path"
if [ ! $? == "0" ];then
	err "Failed to cd \"$app_path\""
	return 1
fi

# Install App #
echo git clone "$app_repo_url"
git clone "$app_repo_url"
cd "$code_path"
if [ ! $? == "0" ];then
	err "Failed to cd \"$code_path\""
	return 1
fi

# Create folder $data_path
echo sudo mkdir -p "$data_path"
sudo mkdir -p "$data_path"

# Contain App. Write docker-compose config. 4
tee "$app_container_config" > /dev/null <<EOF
services:
  hbbs:
    container_name: hbbs
    command: hbbs
    image: rustdesk/rustdesk-server:$app_version
    #environment:
      #- ALWAYS_USE_RELAY=Y
    #network_mode: "host"
    ports:
      - 21115:21115/tcp
      - 21116:21116/tcp
      - 21116:21116/udp
      - 21118:21118/tcp
    volumes:
      - ${data_path}:/root
    depends_on:
      - hbbr
    restart: unless-stopped

  hbbr:
    container_name: hbbr
    command: hbbr
    image: rustdesk/rustdesk-server:$app_version
    #network_mode: "host"
    ports:
      - 21117:21117/tcp
      - 21119:21119/tcp
    volumes:
      - ${data_path}:/root
    restart: unless-stopped
EOF

echo cat ./docker-compose.yml
cat ./docker-compose.yml

# Run App. LIVE!
echo sudo docker-compose pull
sudo docker-compose pull

echo sudo docker-compose down
sudo docker-compose down

echo sudo docker-compose up -d
sudo docker-compose up -d

echo open http://$(host.ip):$app_port

sudo docker logs -f hbbs

}
# ---