# metube.install:  $app_domain $app_port $@
alias mt.install="metube.install mt.$org_domain 8081 $MEDIA_PATH/YT/Download/"
# uses yt-dlp - A feature-rich command-line audio/video downloader - https://github.com/yt-dlp/yt-dlp
metube.install(){

# Config #
app_name="mt" # App Name
app_repo_url="https://github.com/alexta69/metube" # App Codebase
app_version="latest"
app_domain="${1:-"$app_name.$org_domain"}" # Unique app domain
app_port="${2:-"8081"}" # App Port
db_port="$((app_port - 1))" # DB Port
container_name="$app_name-$app_port"
app_domain_filename="$(echo $app_domain | tr "." "-")"
app_path="/data/${app_domain_filename}"
data_path="${3:-"$app_path/${app_name}_data"}"
code_path="$app_path/$(basename $app_repo_url)"
app_container_config="$code_path/docker-compose.yml"

# Setup paths #
mkdir -p "$app_path"
echo cd "$app_path"
cd "$app_path"
if [ ! $? == "0" ];then
	err "Failed to cd \"$app_path\""
	return 1
fi

# Install App #
echo git clone "$app_repo_url"
git clone "$app_repo_url"
cd "$code_path"
if [ ! $? == "0" ];then
	err "Failed to cd \"$code_path\""
	return 1
fi

# Create folder $data_path
echo sudo mkdir -p "$data_path"
sudo mkdir -p "$data_path"
sudo mkdir -p "$data_path/Audio"
sudo mkdir -p "${app_path}/cookies"


# Set permissions $data_path
#echo sudo chown -R 1000:1000 "$data_path"
#sudo chown -R 1000:1000 "$data_path"

# Make
#echo sudo docker build -t $app_name-$app_version .
#time sudo docker build -t $app_name-$app_version .

# Contain App. Write docker-compose config. 4
tee "$app_container_config" > /dev/null <<EOF
services:
  metube:
    container_name: $container_name
    image: "ghcr.io/alexta69/metube"
    environment: 
      DEFAULT_THEME: "auto"
      DOWNLOAD_DIR: "/downloads"
      AUDIO_DOWNLOAD_DIR: "/downloads/Audio"
      #PUBLIC_HOST_URL: "$app_domain"
      #PUBLIC_HOST_AUDIO_URL: "audio.$app_domain"
      ENABLE_ACCESSLOG: "true"
      YTDL_OPTIONS_FILE: "/downloads/ytdl-options.json"
      MAX_CONCURRENT_DOWNLOADS: "1"
      DOWNLOAD_DIRS_INDEXABLE: true
    ports: 
      - "$app_port:8081"
    restart: always
    volumes: 
      - "${data_path}:/downloads"
      - "${app_path}/cookies:/cookies"
      - "${app_path}/ytdl-options.json:/downloads/ytdl-options.json"
    labels:
      - "com.centurylinklabs.watchtower.enable=true"
      - "com.centurylinklabs.watchtower.monitor-only=true"
EOF

tee "$app_path/ytdl-options.json" > /dev/null <<EOF
{
  "sleep_interval":0,
  "max_sleep_interval":0,
  "sleep_interval_requests":0,
  "cookiefile":"/cookies/cookies.txt"
}
EOF

echo cat ./docker-compose.yml
cat ./docker-compose.yml

echo cat "$app_path/ytdl-options.json"
cat "$app_path/ytdl-options.json"

# Run App. LIVE!
echo Running $app_name container in the background.

echo sudo docker-compose pull
sudo docker-compose pull

echo sudo docker-compose down
sudo docker-compose down

rm -v $MEDIA_PATH/YT/Download/.metube/pending
rm -v $MEDIA_PATH/YT/Download/.metube/queue
rm -v $MEDIA_PATH/YT/Download/.metube/queue-shm
rm -v $MEDIA_PATH/YT/Download/.metube/queue-wal

echo open http://$(host.ip):$app_port

echo sudo docker-compose up -d
sudo docker-compose up -d

}
# ---
