# zfs.hold.release:  $zfs_dataset $zfs_hold_name "mirror"
# arc - archive
# arc or mirror
# How to check that all ZFS snapshots within a pool are without holds before destroying that pool - Server Fault - https://serverfault.com/questions/456301/how-to-check-that-all-zfs-snapshots-within-a-pool-are-without-holds-before-destr
alias zfs.release="zfs.hold.release"
zfs.hold.release(){

zfs_dataset="${1:-""}"
zfs_hold_name="${2:-"mirror"}"
zfs_snapshot_userrefs="$(zfs get -Ht snapshot userrefs "$zfs_dataset" | grep -v $'\t'0 | cut -d $'\t' -f 1 )"
zfs_snapshot_userref_count="$(zfs get -Ht snapshot userrefs "$zfs_dataset" | grep -v $'\t'0 | cut -d $'\t' -f 1 | wc -l )"

echo zfs_snapshot_userref_count: $zfs_snapshot_userref_count
if [[ -z "$zfs_snapshot_userref_count" ]] || [[ $zfs_snapshot_userref_count -lt 1 ]];then
  echo zfs_snapshot_userref_count must be greater than 0 else exit
  return 0
fi

snapshots=( $( echo "$zfs_snapshot_userrefs" | tr '\n' '\0' | xargs -0 zfs holds -H | grep "$zfs_hold_name" |  awk '{ print $1 }' | tr '\n' ' ') )

for snapshot in ${snapshots[@]}; do
  echo sudo zfs release $zfs_hold_name $snapshot
  sleep 1
  sudo zfs release $zfs_hold_name $snapshot
done

}
# ---